var samplePageObj = {
  // 샘플 타이틀
  title: '열고정',
  subtitle: '컬럼 고정 기능 예제입니다.',

  // 샘플 설명
  desc: '시트의 좌/우측에 원하는 개수만큼 컬럼을 고정하실 수 있습니다.',

  // 객체 초기화 구문
  init: {
    Def: {
      Row: { CanFormula: 1 }
    },
    // Section 의 너비를 설정 불가능하게 고정.
    Cfg: {
      SearchMode: 0,
      MaxPages: 3,
      DataMerge: 1,
      HeaderMerge: 3,
      SectionCanResize: 1,
      PrevColumnMerge: 0,
      FitWidth: true
    },
    LeftCols: [],
    Cols: [
      {
        Header: [
          '기간',
          '기간',
          '기간'
        ],
        Type: 'Text',
        Name: 'Year',
        Width: '160',
        Align: 'Center',
        CanEdit: 0,
        RawSort: 1
      },
      {
        Header: [
          '자치구',
          '자치구',
          '자치구'
        ],
        Type: 'Text',
        Name: 'Region',
        Radio: 1,
        Width: '120',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1
      },
      {
        Header: [
          '세대',
          '세대',
          '세대'
        ],
        Type: 'Int',
        Name: 'Generation',
        Radio: 1,
        Width: '120',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1
      },
      {
        Header: [
          '인구',
          '한국인',
          '남자'
        ],
        Type: 'Int',
        Name: 'KoMale',
        Radio: 1,
        Width: '120',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1
      },
      {
        Header: [
          '인구',
          '한국인',
          '여자'
        ],
        Type: 'Int',
        Name: 'KoFemale',
        Radio: 1,
        Width: '120',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1
      },
      {
        Header: [
          '인구',
          '한국인',
          '계'
        ],
        Type: 'Int',
        Name: 'KoTotal',
        Radio: 1,
        Width: '120',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1,
        Formula: 'KoMale + KoFemale'
      },
      {
        Header: [
          '인구',
          '등록외국인',
          '남자'
        ],
        Type: 'Int',
        Name: 'FoMale',
        Radio: 1,
        Width: '120',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1
      },
      {
        Header: [
          '인구',
          '등록외국인',
          '여자'
        ],
        Type: 'Int',
        Name: 'FoFemale',
        Radio: 1,
        Width: '120',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1
      },
      {
        Header: [
          '인구',
          '등록외국인',
          '계'
        ],
        Type: 'Int',
        Name: 'FoTotal',
        Radio: 1,
        Width: '120',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1,
        Formula: 'FoMale + FoFemale'
      },
      {
        Header: [
          '인구',
          '합계',
          '남자'
        ],
        Type: 'Int',
        Name: 'ToMale',
        Radio: 1,
        Width: '120',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1,
        Formula: 'FoMale + KoMale'
      },
      {
        Header: [
          '인구',
          '합계',
          '여자'
        ],
        Type: 'Int',
        Name: 'ToFemale',
        Radio: 1,
        Width: '120',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1,
        Formula: 'FoFemale + KoFemale'
      },
      {
        Header: [
          '인구',
          '합계',
          '계'
        ],
        Type: 'Int',
        Name: 'Total',
        Radio: 1,
        Width: '120',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1,
        Formula: 'ToMale + ToFemale'
      },
    ],
    RightCols: [
      {
        Header: [
          '세대당 \n 인구',
          '세대당 \n 인구',
          '세대당 \n 인구'
        ],
        Type: 'Float',
        Name: 'PG',
        Radio: 1,
        Width: '100',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1
      },
      {
        Header: [
          '65세이상 \n 고령자',
          '65세이상 \n 고령자',
          '65세이상 \n 고령자'
        ],
        Type: 'Int',
        Name: 'Elder',
        Radio: 1,
        Width: '100',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1
      },
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<label> 왼쪽 컬럼 고정 갯수</label><input type=\'text\' id=\'left\' min=\'0\' value=\'3\' class=\'mgr10 t-rgt\' style=\'width:60px\'>'
            + '<hr/>'
            + '<label>오른쪽 컬럼 고정 갯수</label><input type=\'number\' id=\'right\' min=\'0\' value=\'2\' class=\'mgr10 t-rgt\' style=\'width:60px\'> '
            + '<hr/>'
            + '<button class=\'mainbtn\' onclick=\'sampleBtn(this)\'> 열고정 </button>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    /* 시트 초기화시 SEQ컬럼을 생성하지 않았다 하더라도
        SEQ컬럼은 히든된 상태로 생성되어있으므로 왼쪽 컬럼은 + 1 */
    var left = +document.getElementById('left').value + 1;
    var right = +document.getElementById('right').value;

    sheet.setFixedCols(left, right, 1);
  },

  // event구문
  event: {
  },

  // data
  data: [
    {
      Year: 2018,
      Region: '종로구',
      Generation: 73735,
      KoMale: 74825,
      KoFemale: 78240,
      FoMale: 4331,
      FoFemale: 5630,
      PG: 2.08,
      Elder: 26742
    },
    {
      Year: 2018,
      Region: '중구',
      Generation: 61502,
      KoMale: 61947,
      KoFemale: 63778,
      FoMale: 4727,
      FoFemale: 5181,
      PG: 2.04,
      Elder: 22005
    },
    {
      Year: 2018,
      Region: '용산구',
      Generation: 108974,
      KoMale: 110640,
      KoFemale: 118359,
      FoMale: 9126,
      FoFemale: 6965,
      PG: 2.10,
      Elder: 37640
    },
    {
      Year: 2018,
      Region: '성동구',
      Generation: 137209,
      KoMale: 151359,
      KoFemale: 156862,
      FoMale: 3732,
      FoFemale: 4510,
      PG: 2.25,
      Elder: 42767
    },
    {
      Year: 2018,
      Region: '광진구',
      Generation: 162606,
      KoMale: 172794,
      KoFemale: 182765,
      FoMale: 6733,
      FoFemale: 8771,
      PG: 2.19,
      Elder: 45619
    },
    {
      Year: 2018,
      Region: '동대문구',
      Generation: 161820,
      KoMale: 173567,
      KoFemale: 174485,
      FoMale: 6207,
      FoFemale: 10079,
      PG: 2.15,
      Elder: 57165
    },
    {
      Year: 2018,
      Region: '중랑구',
      Generation: 180511,
      KoMale: 200419,
      KoFemale: 202790,
      FoMale: 2029,
      FoFemale: 2909,
      PG: 2.23,
      Elder: 61830
    },
    {
      Year: 2018,
      Region: '성북구',
      Generation: 186601,
      KoMale: 211904,
      KoFemale: 223964,
      FoMale: 4591,
      FoFemale: 7228,
      PG: 2.34,
      Elder: 67782
    },
    {
      Year: 2018,
      Region: '강북구',
      Generation: 143395,
      KoMale: 156071,
      KoFemale: 163093,
      FoMale: 1451,
      FoFemale: 2300,
      PG: 2.23,
      Elder: 58196
    },
    {
      Year: 2018,
      Region: '도봉구',
      Generation: 138087,
      KoMale: 166160,
      KoFemale: 173253,
      FoMale: 883,
      FoFemale: 1353,
      PG: 2.46,
      Elder: 55964
    },
    {
      Year: 2018,
      Region: '노원구',
      Generation: 217655,
      KoMale: 263919,
      KoFemale: 279833,
      FoMale: 1951,
      FoFemale: 2457,
      PG: 2.50,
      Elder: 77096
    },
    {
      Year: 2018,
      Region: '은평구',
      Generation: 205001,
      KoMale: 233702,
      KoFemale: 249495,
      FoMale: 1898,
      FoFemale: 2571,
      PG: 2.36,
      Elder: 77420
    },
    {
      Year: 2018,
      Region: '서대문구',
      Generation: 138549,
      KoMale: 149569,
      KoFemale: 160744,
      FoMale: 4247,
      FoFemale: 8520,
      PG: 2.24,
      Elder: 50456
    },
    {
      Year: 2018,
      Region: '마포구',
      Generation: 172505,
      KoMale: 178240,
      KoFemale: 196837,
      FoMale: 4333,
      FoFemale: 6949,
      PG: 2.17,
      Elder: 50833
    },
    {
      Year: 2018,
      Region: '양천구',
      Generation: 176498,
      KoMale: 228634,
      KoFemale: 235551,
      FoMale: 1823,
      FoFemale: 2137,
      PG: 2.63,
      Elder: 58045
    },
    {
      Year: 2018,
      Region: '강서구',
      Generation: 258503,
      KoMale: 290079,
      KoFemale: 306870,
      FoMale: 3210,
      FoFemale: 3452,
      PG: 2.31,
      Elder: 79660
    },
    {
      Year: 2018,
      Region: '구로구',
      Generation: 172457,
      KoMale: 200417,
      KoFemale: 204080,
      FoMale: 19532,
      FoFemale: 14457,
      PG: 2.35,
      Elder: 61801
    },
    {
      Year: 2018,
      Region: '금천구',
      Generation: 107971,
      KoMale: 118915,
      KoFemale: 115002,
      FoMale: 11483,
      FoFemale: 8621,
      PG: 2.17,
      Elder: 35739
    },
    {
      Year: 2018,
      Region: '영등포구',
      Generation: 171085,
      KoMale: 183224,
      KoFemale: 184554,
      FoMale: 20095,
      FoFemale: 15727,
      PG: 2.15,
      Elder: 55673
    },
    {
      Year: 2018,
      Region: '동작구',
      Generation: 177176,
      KoMale: 192533,
      KoFemale: 203670,
      FoMale: 5925,
      FoFemale: 7257,
      PG: 2.24,
      Elder: 59479
    },
    {
      Year: 2018,
      Region: '관악구',
      Generation: 262222,
      KoMale: 252160,
      KoFemale: 249797,
      FoMale: 8582,
      FoFemale: 9501,
      PG: 1.91,
      Elder: 72249
    },
    {
      Year: 2018,
      Region: '서초구',
      Generation: 172918,
      KoMale: 207868,
      KoFemale: 226083,
      FoMale: 2109,
      FoFemale: 2103,
      PG: 2.51,
      Elder: 54751
    },
    {
      Year: 2018,
      Region: '강남구',
      Generation: 228775,
      KoMale: 259611,
      KoFemale: 282753,
      FoMale: 2592,
      FoFemale: 2497,
      PG: 2.37,
      Elder: 67085
    },
    {
      Year: 2018,
      Region: '송파구',
      Generation: 270866,
      KoMale: 323526,
      KoFemale: 343109,
      FoMale: 3323,
      FoFemale: 3549,
      PG: 2.46,
      Elder: 81364
    },
    {
      Year: 2018,
      Region: '강동구',
      Generation: 177247,
      KoMale: 211816,
      KoFemale: 215757,
      FoMale: 2037,
      FoFemale: 2310,
      PG: 2.41,
      Elder: 58770
    },
    {
      Year: 2017,
      Region: '종로구',
      Generation: 73594,
      KoMale: 75967,
      KoFemale: 78803,
      FoMale: 4127,
      FoFemale: 5360,
      PG: 2.10,
      Elder: 26182
    },
    {
      Year: 2017,
      Region: '중구',
      Generation: 60412,
      KoMale: 62253,
      KoFemale: 63456,
      FoMale: 4084,
      FoFemale: 4800,
      PG: 2.08,
      Elder: 21384
    },
    {
      Year: 2017,
      Region: '용산구',
      Generation: 107666,
      KoMale: 110878,
      KoFemale: 118283,
      FoMale: 8545,
      FoFemale: 6738,
      PG: 2.13,
      Elder: 36882
    },
    {
      Year: 2017,
      Region: '성동구',
      Generation: 132902,
      KoMale: 150368,
      KoFemale: 154440,
      FoMale: 3709,
      FoFemale: 4194,
      PG: 2.29,
      Elder: 41273
    },
    {
      Year: 2017,
      Region: '광진구',
      Generation: 160798,
      KoMale: 174414,
      KoFemale: 183289,
      FoMale: 6231,
      FoFemale: 8364,
      PG: 2.22,
      Elder: 43953
    },
    {
      Year: 2017,
      Region: '동대문구',
      Generation: 159938,
      KoMale: 175324,
      KoFemale: 175323,
      FoMale: 5861,
      FoFemale: 9503,
      PG: 2.19,
      Elder: 55718
    },
    {
      Year: 2017,
      Region: '중랑구',
      Generation: 179132,
      KoMale: 203325,
      KoFemale: 204901,
      FoMale: 1800,
      FoFemale: 2754,
      PG: 2.28,
      Elder: 59262
    },
    {
      Year: 2017,
      Region: '성북구',
      Generation: 187112,
      KoMale: 216556,
      KoFemale: 227499,
      FoMale: 4547,
      FoFemale: 6805,
      PG: 2.37,
      Elder: 66251
    },
    {
      Year: 2017,
      Region: '강북구',
      Generation: 142533,
      KoMale: 158918,
      KoFemale: 165561,
      FoMale: 1334,
      FoFemale: 2189,
      PG: 2.28,
      Elder: 56530
    },
    {
      Year: 2017,
      Region: '도봉구',
      Generation: 137378,
      KoMale: 168759,
      KoFemale: 175407,
      FoMale: 794,
      FoFemale: 1274,
      PG: 2.51,
      Elder: 53488
    },
    {
      Year: 2017,
      Region: '노원구',
      Generation: 217619,
      KoMale: 269508,
      KoFemale: 284895,
      FoMale: 1517,
      FoFemale: 2155,
      PG: 2.55,
      Elder: 74243
    },
    {
      Year: 2017,
      Region: '은평구',
      Generation: 202839,
      KoMale: 236353,
      KoFemale: 250441,
      FoMale: 1870,
      FoFemale: 2538,
      PG: 2.40,
      Elder: 74559
    },
    {
      Year: 2017,
      Region: '서대문구',
      Generation: 137266,
      KoMale: 151144,
      KoFemale: 161656,
      FoMale: 4106,
      FoFemale: 8122,
      PG: 2.28,
      Elder: 49266
    },
    {
      Year: 2017,
      Region: '마포구',
      Generation: 169408,
      KoMale: 178939,
      KoFemale: 195976,
      FoMale: 4309,
      FoFemale: 6559,
      PG: 2.21,
      Elder: 49615
    },
    {
      Year: 2017,
      Region: '양천구',
      Generation: 176649,
      KoMale: 232518,
      KoFemale: 238636,
      FoMale: 1761,
      FoFemale: 2103,
      PG: 2.67,
      Elder: 55234
    },
    {
      Year: 2017,
      Region: '강서구',
      Generation: 254257,
      KoMale: 292989,
      KoFemale: 308702,
      FoMale: 3186,
      FoFemale: 3378,
      PG: 2.37,
      Elder: 76032
    },
    {
      Year: 2017,
      Region: '구로구',
      Generation: 171570,
      KoMale: 204003,
      KoFemale: 206739,
      FoMale: 17383,
      FoFemale: 13434,
      PG: 2.39,
      Elder: 58794
    },
    {
      Year: 2017,
      Region: '금천구',
      Generation: 106066,
      KoMale: 119497,
      KoFemale: 115657,
      FoMale: 10278,
      FoFemale: 8059,
      PG: 2.22,
      Elder: 34170
    },
    {
      Year: 2017,
      Region: '영등포구',
      Generation: 167355,
      KoMale: 183975,
      KoFemale: 184575,
      FoMale: 18425,
      FoFemale: 15049,
      PG: 2.20,
      Elder: 53981
    },
    {
      Year: 2017,
      Region: '동작구',
      Generation: 172995,
      KoMale: 193255,
      KoFemale: 202962,
      FoMale: 5572,
      FoFemale: 6704,
      PG: 2.29,
      Elder: 57255
    },
    {
      Year: 2017,
      Region: '관악구',
      Generation: 255352,
      KoMale: 253661,
      KoFemale: 249636,
      FoMale: 8345,
      FoFemale: 9287,
      PG: 1.97,
      Elder: 70046
    },
    {
      Year: 2017,
      Region: '서초구',
      Generation: 173594,
      KoMale: 211236,
      KoFemale: 229866,
      FoMale: 2186,
      FoFemale: 2113,
      PG: 2.54,
      Elder: 53205
    },
    {
      Year: 2017,
      Region: '강남구',
      Generation: 231612,
      KoMale: 266442,
      KoFemale: 289722,
      FoMale: 2499,
      FoFemale: 2389,
      PG: 2.40,
      Elder: 65060
    },
    {
      Year: 2017,
      Region: '송파구',
      Generation: 264628,
      KoMale: 323147,
      KoFemale: 341349,
      FoMale: 3260,
      FoFemale: 3417,
      PG: 2.51,
      Elder: 76582
    },
    {
      Year: 2017,
      Region: '강동구',
      Generation: 177407,
      KoMale: 216777,
      KoFemale: 219446,
      FoMale: 1922,
      FoFemale: 2214,
      PG: 2.46,
      Elder: 56161
    },
    {
      Year: 2016,
      Region: '종로구',
      Generation: 72118,
      KoMale: 75201,
      KoFemale: 77536,
      FoMale: 4121,
      FoFemale: 5064,
      PG: 2.12,
      Elder: 25091
    },
    {
      Year: 2016,
      Region: '중구',
      Generation: 59651,
      KoMale: 62204,
      KoFemale: 63045,
      FoMale: 4248,
      FoFemale: 4912,
      PG: 2.10,
      Elder: 20606
    },
    {
      Year: 2016,
      Region: '용산구',
      Generation: 106607,
      KoMale: 111601,
      KoFemale: 118640,
      FoMale: 8035,
      FoFemale: 6826,
      PG: 2.16,
      Elder: 35915
    },
    {
      Year: 2016,
      Region: '성동구',
      Generation: 128727,
      KoMale: 148326,
      KoFemale: 150933,
      FoMale: 3680,
      FoFemale: 4222,
      PG: 2.32,
      Elder: 39262
    },
    {
      Year: 2016,
      Region: '광진구',
      Generation: 158390,
      KoMale: 174797,
      KoFemale: 182418,
      FoMale: 6454,
      FoFemale: 8435,
      PG: 2.26,
      Elder: 41441
    },
    {
      Year: 2016,
      Region: '동대문구',
      Generation: 159426,
      KoMale: 177640,
      KoFemale: 177429,
      FoMale: 5804,
      FoFemale: 9439,
      PG: 2.23,
      Elder: 53460
    },
    {
      Year: 2016,
      Region: '중랑구',
      Generation: 177400,
      KoMale: 204900,
      KoFemale: 206105,
      FoMale: 1872,
      FoFemale: 2800,
      PG: 2.32,
      Elder: 55914
    },
    {
      Year: 2016,
      Region: '성북구',
      Generation: 188304,
      KoMale: 219951,
      KoFemale: 230404,
      FoMale: 4553,
      FoFemale: 6709,
      PG: 2.39,
      Elder: 64015
    },
    {
      Year: 2016,
      Region: '강북구',
      Generation: 141229,
      KoMale: 160861,
      KoFemale: 166334,
      FoMale: 1350,
      FoFemale: 2159,
      PG: 2.32,
      Elder: 54053
    },
    {
      Year: 2016,
      Region: '도봉구',
      Generation: 136898,
      KoMale: 171238,
      KoFemale: 176982,
      FoMale: 768,
      FoFemale: 1284,
      PG: 2.54,
      Elder: 50510
    },
    {
      Year: 2016,
      Region: '노원구',
      Generation: 219736,
      KoMale: 276333,
      KoFemale: 291248,
      FoMale: 1533,
      FoFemale: 2098,
      PG: 2.58,
      Elder: 70887
    },
    {
      Year: 2016,
      Region: '은평구',
      Generation: 201891,
      KoMale: 239183,
      KoFemale: 252293,
      FoMale: 1865,
      FoFemale: 2596,
      PG: 2.43,
      Elder: 71457
    },
    {
      Year: 2016,
      Region: '서대문구',
      Generation: 136766,
      KoMale: 152510,
      KoFemale: 161684,
      FoMale: 4087,
      FoFemale: 7590,
      PG: 2.30,
      Elder: 47653
    },
    {
      Year: 2016,
      Region: '마포구',
      Generation: 169432,
      KoMale: 182162,
      KoFemale: 197730,
      FoMale: 4506,
      FoFemale: 6489,
      PG: 2.24,
      Elder: 48303
    },
    {
      Year: 2016,
      Region: '양천구',
      Generation: 177434,
      KoMale: 236290,
      KoFemale: 241449,
      FoMale: 1873,
      FoFemale: 2233,
      PG: 2.69,
      Elder: 52063
    },
    {
      Year: 2016,
      Region: '강서구',
      Generation: 245045,
      KoMale: 290478,
      KoFemale: 305007,
      FoMale: 3256,
      FoFemale: 3363,
      PG: 2.43,
      Elder: 71062
    },
    {
      Year: 2016,
      Region: '구로구',
      Generation: 172220,
      KoMale: 207667,
      KoFemale: 209884,
      FoMale: 17744,
      FoFemale: 14305,
      PG: 2.42,
      Elder: 55705
    },
    {
      Year: 2016,
      Region: '금천구',
      Generation: 104483,
      KoMale: 119885,
      KoFemale: 115501,
      FoMale: 10544,
      FoFemale: 8724,
      PG: 2.25,
      Elder: 32279
    },
    {
      Year: 2016,
      Region: '영등포구',
      Generation: 165729,
      KoMale: 185200,
      KoFemale: 185413,
      FoMale: 19512,
      FoFemale: 16654,
      PG: 2.24,
      Elder: 51844
    },
    {
      Year: 2016,
      Region: '동작구',
      Generation: 172506,
      KoMale: 196267,
      KoFemale: 204730,
      FoMale: 5575,
      FoFemale: 6675,
      PG: 2.32,
      Elder: 55231
    },
    {
      Year: 2016,
      Region: '관악구',
      Generation: 251955,
      KoMale: 256143,
      KoFemale: 250708,
      FoMale: 8891,
      FoFemale: 9865,
      PG: 2.01,
      Elder: 66952
    },
    {
      Year: 2016,
      Region: '서초구',
      Generation: 173970,
      KoMale: 214673,
      KoFemale: 232519,
      FoMale: 2213,
      FoFemale: 2072,
      PG: 2.57,
      Elder: 50984
    },
    {
      Year: 2016,
      Region: '강남구',
      Generation: 234080,
      KoMale: 271604,
      KoFemale: 295511,
      FoMale: 2613,
      FoFemale: 2412,
      PG: 2.42,
      Elder: 61931
    },
    {
      Year: 2016,
      Region: '송파구',
      Generation: 258382,
      KoMale: 320557,
      KoFemale: 337274,
      FoMale: 3530,
      FoFemale: 3585,
      PG: 2.55,
      Elder: 71064
    },
    {
      Year: 2016,
      Region: '강동구',
      Generation: 177460,
      KoMale: 221118,
      KoFemale: 223050,
      FoMale: 1963,
      FoFemale: 2340,
      PG: 2.50,
      Elder: 53195
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
